extensions [
  profiler
  table
]
patches-own [
  expandSite
  id
  fitness
]

globals [

  ;cellColor
  ;cellIdentity
  tickInduce
  tickFit
  yellowInitial
  blueInitial
  yellowRelative
  blueRelative

  fitInduced
  cloneDist
  counter
]

to reset
  set advantageP 0.6
  set fitnessDistribution false
  set trackdelay 0
  set induction 0.02
  set localgrowth "Neighbour8"
  set locationLabelInduction 0.2
  set constantmutation false
  set plotdistribution true
  set refreshfrequency 1
  set labeltime 20
  set inductiontime 12
  set labelInduction 1
  set trackall true
  set transientfitness false
  set inducelabel false
  set distribution "Normal"
  set secondfitness 0.55
  set secondpopulationfreq 0.5
end

to setup
  clear-all
  ask patches [
    set pcolor 135
    set id -1
    set fitness 0.5
  ]
  set yellowInitial 0
  set blueInitial 0
  set yellowRelative 0
  set blueRelative 0
  set fitInduced 0
  set counter 0
  set cloneDist []
  reset-ticks
end

to-report pDiv [ cell adjacent ]
  let p ( [ fitness ] of cell ) - ( [ fitness ] of adjacent ) + 0.5
  report ( p )
end

to-report cumsum [ xs]
  report reduce [ [ a b ] -> lput ( b + last a) a ]
                (fput (list first xs) butfirst xs)
end

to-report safeLog [ n base ]
  let result 0
  if (n != 0 ) [ set result log n base ]
  report ( result )
end

to-report clone-size-frequency [ ids ]
  let clones remove-duplicates ids
  let numClones length clones
  ;print numClones
  ;let sizes []
  ;foreach clones [ x ->
  ;  let y length filter  [ i -> i = x ] ids
  ;  set sizes lput y sizes
  ;]
  let sizeD table:make
  foreach ids [ x ->
    ifelse (table:has-key? sizeD x) [
     table:put sizeD x (table:get sizeD x ) + 1
    ] [
     table:put sizeD x 1
    ]
  ]
  let sizes map [ x -> item 1 x ] table:to-list sizeD
  ;print sizes
  let maxSize max sizes
  let totalPop length ids
  let meanSize totalPop / numClones
  let sizeRange n-values maxSize [ i -> i + 1]

  ;let dist []
  let distD table:make
  foreach sizes [ s ->
    ifelse (table:has-key? distD s) [
     table:put distD s (table:get distD s ) + 1
    ] [
     table:put distD s 1
    ]
  ]
  let dist []
  foreach sizeRange [ s ->
    ifelse (table:has-key? distD s) [
      set dist lput ( (table:get distD s ) * 100 / numClones ) dist
    ] [
      set dist lput 0 dist
    ]
  ]
  ;foreach sizeRange [ s ->
  ;  let y length filter [ i -> i = s ] sizes
    ;set dist lput list (s / meanSize ) ( y ) dist
  ;  set dist lput ( y * 100 / numClones ) dist
  ;]
  ;print dist
  ;reverse cumsum reverse
  set dist reverse dist
  set dist cumsum dist
  set dist reverse dist
  set dist ( map [ [a b ] -> list (a / meanSize ) (log b 10 ) ] sizeRange dist )
  report dist
end

to-report add [ a b ]

  report a + b
end

to-report getRandom [ p sd ]
  let result 0.
  ifelse ( Distribution = "Normal" ) [
    set result (random-normal p sd)
  ] [ ifelse ( Distribution = "Exponential" ) [
   set result (random-exponential p)
    ] [ ifelse ( Distribution = "2-Value" ) [
        ifelse ( random-float 1 > secondPopulationFreq ) [set result p] [set result secondFitness] ]
      [ ifelse ( Distribution = "Uniform") [set result ( ( random-float ( 2 * sd ) ) + p - sd ) ] [error "Unknown distribution"] ]
    ]
    ]
  report result
end

to go

  if (counter = inductionTime) [set transientFitness true]
  if (counter = labelTime) [set induceLabel true]

  set yellowRelative 0
  set blueRelative 0

  set tickInduce induceLabel
  set tickFit transientFitness
  ask patches [

    ;pick a neighbour
    ifelse localGrowth = "Neighbour8" [
      set expandSite one-of neighbors
    ] [
      ifelse localGrowth = "Global" [ set expandSite one-of patches ] [
        ifelse localGrowth = "Neighbour4" [set expandSite one-of neighbors4 ] [error "Unknown neighbourhood"]
      ]
    ]
    let cellColor pcolor
    ;do I gain a fitness enhancing mutation/colour?
    if (constantMutation or tickFit) and (pcolor = 135) [
      let fit induction > random-float 1.
      if fit [
        set pcolor 65
        ifelse ( fitnessDistribution ) [ set fitness getRandom advantageP fitnessSD ] [ set fitness advantageP ]
      ]
      ;if ( fit or trackAll ) and ( random-float 1. < labelInduction )  [
      ;  set id fitInduced
      ;  set fitInduced (fitInduced + 1)
      ;]

    ]

    if (counter = inductionTime + trackDelay ) and ( (pcolor != 135) or trackAll ) and ( random-float 1. < labelInduction )  [
        set id fitInduced
        set fitInduced (fitInduced + 1)
      ]

    ;induce a colour label for mutated clones. If I'm on a boundary (pink), 85=cyan, if I'm surrounded by fit mutants, 45=yellow
    if tickInduce and (random-float 1 < locationLabelInduction) and (pcolor = 65) [
      ifelse ((count neighbors with [pcolor = 135]) = 0) [
        set pcolor 45
        set yellowInitial (yellowInitial + 1)
      ] [
        set pcolor 85
        set blueInitial (blueInitial + 1)
      ]
    ]
    ;reset cellColor
    set cellColor pcolor
    let cellIdentity id
    let cellFit fitness
    ;do I divide?
    ;use fitness of fitter clone to decide
    ;;Both are pink or both are non-pink - no advantagee
    ;ifelse (pcolor = 135 and [pcolor] of expandSite = 135) or (pcolor != 135 and [pcolor] of expandSite != 135) [
    ;  if ( 0.5 < random-float 1.) [ask expandSite [
    ;    set pcolor cellColor
    ;    set id cellIdentity
    ;  ]]
    ;] [
      ;Random chance of expanding based on fitness
    let p ( pDiv self expandSite )
    if ( p > random-float 1. ) [ask expandSite [
      set pcolor cellColor
      set id cellIdentity
      set fitness cellFit
    ] ]
  ]
    ;  ifelse ( [fitness] of expandSite > cellFit ) [
    ;    if ( [fitness] of expandSite < random-float 1.) [ask expandSite [
    ;      set pcolor cellColor
    ;      set id cellIdentity
    ;      set fitness cellFit
    ;  ]] ] [
    ;    if ( cellFit > random-float 1.) [ask expandSite [
    ;      set pcolor cellColor
    ;      set id cellIdentity
    ;      set fitness cellFit
    ;  ]] ]
    ;]


  if (tickInduce and induceLabel) [set induceLabel false]
  if (tickFit and transientFitness) [ set transientFitness false ]
  if (yellowInitial > 0) [set yellowRelative ( count patches with [pcolor = 45 ]) / yellowInitial]
  if (blueInitial > 0) [set blueRelative ( count patches with [pcolor = 85 ]) / blueInitial]
  if (counter mod refreshFrequency = 0) and PlotDistribution and (fitInduced > 0) [set cloneDist (clone-size-frequency filter  [ i -> i >= 0 ] [id] of patches )]
  set counter counter + 1
  tick
end
@#$#@#$#@
GRAPHICS-WINDOW
471
63
832
433
-1
-1
0.136
1
10
1
1
1
0
1
1
1
-180
180
-180
180
1
1
1
ticks
30.0

BUTTON
169
176
237
209
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
79
176
151
209
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
38
354
432
603
Relative size of boundary/core clones
Time
Number
0.0
100.0
0.0
2.0
true
true
"" ""
PENS
"core" 1.0 0 -1184463 true "" "plot yellowRelative "
"edge" 1.0 0 -11221820 true "" "plot blueRelative"

SLIDER
76
260
248
293
induction
induction
00.0001
0.1
0.02
0.0001
1
NIL
HORIZONTAL

SLIDER
76
305
246
338
advantageP
advantageP
0
1
0.6
0.01
1
NIL
HORIZONTAL

SLIDER
897
67
1075
100
locationLabelInduction
locationLabelInduction
0
1
0.2
0.05
1
NIL
HORIZONTAL

SWITCH
879
507
998
540
Inducelabel
Inducelabel
1
1
-1000

SWITCH
1134
64
1281
97
TransientFitness
TransientFitness
1
1
-1000

SWITCH
1133
117
1289
150
ConstantMutation
ConstantMutation
1
1
-1000

MONITOR
304
17
400
62
Tracked clones
fitInduced
0
1
11

MONITOR
305
74
397
119
Wild type cells
count patches with [pcolor = 135]
17
1
11

PLOT
464
458
862
671
Clone size distribution
Clone size (normalised)
Relative frequency (log10)
0.0
10.0
-1.0
2.0
false
false
"" ""
PENS
"default" 0.001 2 -16777216 true "" "plot-pen-reset foreach cloneDist [ a -> plotxy first a last a]"

SWITCH
901
115
1040
148
PlotDistribution
PlotDistribution
0
1
-1000

SLIDER
902
160
1074
193
RefreshFrequency
RefreshFrequency
1
100
1.0
1
1
NIL
HORIZONTAL

SLIDER
1066
454
1238
487
InductionTime
InductionTime
-1
100
12.0
1
1
NIL
HORIZONTAL

SWITCH
878
553
981
586
TrackAll
TrackAll
0
1
-1000

SLIDER
878
455
1050
488
LabelTime
LabelTime
-1
100
20.0
1
1
NIL
HORIZONTAL

SWITCH
1131
205
1288
238
FitnessDistribution
FitnessDistribution
1
1
-1000

SLIDER
1132
246
1304
279
FitnessSD
FitnessSD
0
1
0.1
0.01
1
NIL
HORIZONTAL

MONITOR
279
258
434
303
mean fitness
mean [fitness] of patches
5
1
11

CHOOSER
1138
338
1276
383
Distribution
Distribution
"Normal" "Exponential" "Uniform" "2-Value" "Error"
0

SLIDER
1055
513
1227
546
LabelInduction
LabelInduction
0
1
1.0
0.01
1
NIL
HORIZONTAL

TEXTBOX
890
414
1040
442
Clone size tracking\n parameters
11
0.0
1

SLIDER
1068
576
1240
609
TrackDelay
TrackDelay
-20
20
0.0
1
1
NIL
HORIZONTAL

MONITOR
305
132
407
177
Surviving clones
length remove-duplicates [id] of patches
17
1
11

PLOT
38
609
238
759
Surviving clones (log10)
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot log ( length remove-duplicates [id] of patches)  10"

PLOT
243
610
443
760
Surviving clones
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot ( length remove-duplicates [id] of patches)"

CHOOSER
938
300
1076
345
LocalGrowth
LocalGrowth
"Global" "Neighbour8" "Neighbour4" "Error"
1

SLIDER
1138
387
1310
420
SecondFitness
SecondFitness
0
1
0.55
0.01
1
NIL
HORIZONTAL

SLIDER
1138
420
1311
453
SecondPopulationFreq
SecondPopulationFreq
0
1
0.5
0.01
1
NIL
HORIZONTAL

BUTTON
130
221
193
254
NIL
reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
906
20
1056
42
Advanced options
18
0.0
1

TEXTBOX
100
21
250
43
Basic options
18
0.0
1

TEXTBOX
65
48
268
188
To run the model, click setup, then go. The induction level is set by induction, whilst the relative advantage is set by advantageP.\n\nMore options are available on the right. If you want to reset all options back to their defaults, click reset.
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

A spatial Moran-like model showing the competition between two populations of cells (pink vs green) with different fitnesses, and the impact on the clone growth. From Colom et al 2020.

## HOW IT WORKS

At each timepoint, every cell (patch) gets the opportunity to divide and replace one randomly selected neighbour. The decision to divide is determined randomly based on the relative fitness of the dividing cell and the selected neighbour. Cell division occurs if a random number from 0 to 1 is less than the difference between the dividing cell and its neighbour plus 0.5. For example, a cell with fitness of 0.5 attempting to replace a neighbour with a fitness of 0.5 will be successful 50 % of the time. When a cell successfully divides, it changes the colour, the fitness, and the clone tracking id of the replaced neighbour to match its own values. 

Initially all cells are pink and have no unique tracking IDs. If the switch transient fitness is activated, it remains active for one tick and a subset of cells (determined by "induction") are mutated. This can be triggered automatically by setting "InductionTime" to a value greater than -1. Mutated cells turn green, and their fitness is reset from the initial value of 0.5. This value can be replaced by a single value (equal to "advantageP", if "FitnessDistribution" is off) or with a distribution ("FitnessDistribution" is on).  

Clone size tracking is initiated on induction, or after a small delay (set with "TrackDelay"). A subset of mutated cells (or all cells if "TrackAll" is on) are given a unique identifier, and the number of clones with each identifier counted and the cumulative size distribution plotted. The relative proportion of the subset is determined by "LabelInduction".

An additional form of clone tracking is started at "InductionTime", where patches that share a boundary with wild type cells are coloured cyan and those that do not are coloured yellow. This can be done manually by setting "InductionTime" to -1 and turning "InductionLabel" on as a simulation runs. The relative size of these populations is measured and plotted over time.

The parameters for the distribution of fitness values are controlled with controls "AdvantageP", "Distribution", "FitnessSD", "SecondFitness", and "SecondFitnessFreq". If a normal distribution is selected, "AdvantageP" is the mean and "FitnessSD" is one standard deviation. If a uniform distribution is selected in the range "AdvantageP"+"FitnessSD" to "AdvantageP"-"FitnessSD". If an exponential distribution is selected, the mean is "AdvantageP". If "2-Value" is selected, a subset of mutated cells have fitness "AdvantageP", whilst the others have fitness "SecondFitness". The proportion of cells with the second fitness is determined by "SecondFitnessFreq".

Finally, the neighbourhood used to pick the cell to replace is set using the "LocalGrowth" selector. Users can select between picking neighbours from the 4 or 8 directly adjacent cells, or from the whole system ("global").

If you select "Error" in any of the drop down menus, the simulation will not run and you will get an error. This has been included to aid code testing and not part of the model.

## HOW TO USE IT

Use the available buttons to select underlying model parameters. 

The SETUP button initializes the model.

The GO button starts it running.

## THINGS TO NOTICE

We recommend that you start with pAdvantage=0.6 and no distribution. Though the result is stochastic, you should expect to see the following

* The green cells take over the tissue quickly 

* The clone size distribution goes from a straight line, to a kinked line, to something approximately straight (though with a slight downward bend)

* The yellow (enclosed) cell population remains roughly static, whilst the cyan population (bordering wildtype cells) grows.

If you use a fitness distribution you can observe a greater clone loss over time as exceptionally fit clones takeover. This is most clear using an exponential distribution.


## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the model itself:

* Colom et al 2020, TBT

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 2020 Ben Hall.

![CC BY-SA 3.0](https://creativecommons.org/licenses/by-sa/3.0/)

This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 License.  

<!-- 2019 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
